/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.console.content;

import filenet.sim.api.VWSIMSimulationVerifyException;
import filenet.sim.toolkit.console.VWSIMBaseNode;
import filenet.sim.toolkit.console.VWSIMCategoryRender;
import filenet.sim.toolkit.console.VWSIMConsoleContextMenu;
import filenet.sim.toolkit.console.VWSIMConsolePerformer;
import filenet.sim.toolkit.console.VWSIMFolderNode;
import filenet.sim.toolkit.console.VWSIMScenarioNode;
import filenet.sim.toolkit.console.VWSIMSimulationNode;
import filenet.sim.toolkit.console.content.VWSIMConsoleContentViewPane;
import filenet.sim.toolkit.console.content.VWSIMListViewTableModel;
import filenet.sim.toolkit.console.content.VWSIMSimulationStatusRender;
import filenet.sim.toolkit.console.images.VWSIMImageLoader;
import filenet.sim.toolkit.console.resources.VWSIMResource;
import filenet.vw.base.VWDebug;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import filenet.vw.idm.toolkit.IVWIDMItem;
import filenet.vw.toolkit.utils.IVWMouseActionListener;
import filenet.vw.toolkit.utils.VWMouseAdapter;
import filenet.vw.toolkit.utils.table.VWTable;
import filenet.vw.toolkit.utils.table.VWTableCellEditor;
import filenet.vw.toolkit.utils.table.VWTableCellRenderer;
import filenet.vw.toolkit.utils.table.VWTableHeaderRenderer;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class VWSIMListViewPane
extends JScrollPane
implements ListSelectionListener,
IVWMouseActionListener {
    private VWSIMConsoleContentViewPane m_contentViewPane = null;
    private VWMouseAdapter m_aMouseAdapter = null;
    private VWTable m_propertyTable = null;
    private VWSIMListViewTableModel m_tableModel = null;
    private Vector m_nodeList = new Vector();
    private VWSIMConsolePerformer m_performer = null;
    private ListSelectionModel m_tableSelectionModel = null;

    public VWSIMListViewPane(VWSIMConsoleContentViewPane contentViewPane) {
        try {
            this.m_contentViewPane = contentViewPane;
            this.setBackground(Color.white);
            this.m_aMouseAdapter = new VWMouseAdapter(this);
            this.m_performer = this.m_contentViewPane.m_performer;
            this.createPropertyTable();
            this.getViewport().add(this.m_propertyTable);
            this.m_propertyTable.addMouseListener(this.m_aMouseAdapter);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (this.m_propertyTable == null) {
                return;
            }
            if (!event.getValueIsAdjusting()) {
                int rowIndex = this.m_propertyTable.getSelectedRow();
                if (rowIndex < 0) {
                    return;
                }
                VWSIMBaseNode aNode = this.m_tableModel.getRowItemAt(rowIndex);
                this.m_contentViewPane.changeFocus(aNode);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void doubleClickedItem(MouseEvent event) {
        try {
            if (this.m_propertyTable == null) {
                return;
            }
            int rowIndex = this.m_propertyTable.getSelectedRow();
            if (rowIndex == -1) {
                return;
            }
            VWSIMBaseNode aNode = this.m_tableModel.getRowItemAt(rowIndex);
            switch (aNode.getType()) {
                case 16: 
                case 18: {
                    this.m_contentViewPane.changeFocus(aNode);
                    this.m_contentViewPane.refreshContent();
                    break;
                }
                case 33: {
                    this.m_contentViewPane.changeFocus(aNode);
                    VWSIMScenarioNode aScnNode = (VWSIMScenarioNode)aNode;
                    if (!aScnNode.canViewContent()) break;
                    this.m_performer.launchScenarioDesigner(aNode);
                    break;
                }
                case 34: {
                    this.m_contentViewPane.changeFocus(aNode);
                    try {
                        VWSIMSimulationNode aSimNode = (VWSIMSimulationNode)aNode;
                        if (aSimNode.canViewContent()) {
                            this.m_performer.viewAnimation(aNode);
                        }
                        break;
                    }
                    catch (VWSIMSimulationVerifyException verifyEx) {
                        if (aNode.getType() == 34) {
                            VWSIMSimulationNode aSimNode = (VWSIMSimulationNode)aNode;
                            String msg = VWSIMResource.FailedVerifySimulationDoDelete.toString(aSimNode.getName());
                            int ret = JOptionPane.showConfirmDialog(this, msg, VWSIMResource.Error, 1);
                            if (ret == 0) {
                                IVWIDMDocument aIVWIDMDocument = (IVWIDMDocument)aSimNode.getIdmItem();
                                aIVWIDMDocument.delete();
                                this.deleteSelectedRow();
                            }
                            break;
                        }
                        VWDebug.logException(verifyEx);
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void createPopup(MouseEvent event) {
        try {
            int selectedRow = this.m_propertyTable.getSelectedRow();
            if (selectedRow >= 0) {
                VWSIMBaseNode aBaseNode = this.m_tableModel.getRowItemAt(selectedRow);
                VWSIMConsoleContextMenu mi = null;
                switch (aBaseNode.getType()) {
                    case 34: {
                        mi = new VWSIMConsoleContextMenu(4, this.m_contentViewPane);
                        mi.setSimulationNodeMenus((VWSIMSimulationNode)aBaseNode);
                        mi.show(event.getComponent(), event.getX(), event.getY());
                        break;
                    }
                    case 33: {
                        mi = new VWSIMConsoleContextMenu(3, this.m_contentViewPane);
                        mi.setScenarioNodeMenus((VWSIMScenarioNode)aBaseNode);
                        mi.show(event.getComponent(), event.getX(), event.getY());
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void displayContent(VWSIMBaseNode node) {
        if (node.isFolderNode()) {
            VWSIMFolderNode aFolder = (VWSIMFolderNode)node;
            this.m_nodeList = aFolder.getSimContent(true);
        }
        this.setListData(this.m_nodeList);
        this.m_tableModel.fireTableDataChanged();
    }

    private synchronized void setListData(Vector list) {
        this.m_tableModel.setData(list);
    }

    public void clearSelection() {
        this.m_propertyTable.clearSelection();
    }

    public void deleteSelectedRow() {
        int rowId = this.m_propertyTable.getSelectedRow();
        this.m_tableModel.removeRow(rowId);
    }

    public void addRow(Object obj) {
        this.m_tableModel.addRow(obj);
    }

    protected int getSelectedRow() {
        return this.m_propertyTable.getSelectedRow();
    }

    protected VWSIMBaseNode getItemAt(int rowIndex) {
        VWSIMBaseNode aNode = null;
        if (rowIndex >= 0) {
            aNode = this.m_tableModel.getRowItemAt(rowIndex);
        }
        return aNode;
    }

    protected String getSelectedItemId() {
        IVWIDMItem sIdmItem;
        String strId = null;
        VWSIMBaseNode aNode = this.getItemAt(this.getSelectedRow());
        if (aNode != null && (sIdmItem = aNode.getIdmItem()) != null) {
            strId = sIdmItem.getId();
        }
        return strId;
    }

    protected VWSIMBaseNode setSelectedRow(int idx) {
        VWSIMBaseNode simNode = null;
        if (idx >= 0) {
            this.m_propertyTable.setRowSelectionInterval(idx, idx);
            simNode = this.m_tableModel.getRowItemAt(idx);
        }
        return simNode;
    }

    protected int findItem(String itemId) {
        int idx = -1;
        if (itemId == null || itemId.length() <= 0) {
            return idx;
        }
        int sz = this.m_nodeList.size();
        if (sz > 0) {
            for (int i = 0; i < sz; ++i) {
                String cId;
                IVWIDMItem idmItem;
                VWSIMBaseNode rowNode = (VWSIMBaseNode)this.m_nodeList.elementAt(i);
                if (rowNode == null || (idmItem = rowNode.getIdmItem()) == null || itemId.compareTo(cId = idmItem.getId()) != 0) continue;
                idx = i;
                break;
            }
        }
        return idx;
    }

    protected void fireTableDataChanged() {
        this.m_tableModel.fireTableDataChanged();
    }

    private void createPropertyTable() {
        try {
            this.m_tableModel = new VWSIMListViewTableModel(this.m_nodeList);
            this.m_propertyTable = new VWTable(this.m_tableModel);
            this.m_propertyTable.setRowSelectionAllowed(true);
            this.m_propertyTable.setColumnSelectionAllowed(false);
            this.m_propertyTable.setShowGrid(false);
            this.m_propertyTable.setDefaultRenderer(String.class, new VWTableCellRenderer());
            this.m_propertyTable.setDefaultEditor(String.class, new VWTableCellEditor(new JTextField()));
            this.m_tableSelectionModel = this.m_propertyTable.getSelectionModel();
            this.m_tableSelectionModel.setSelectionMode(0);
            this.m_tableSelectionModel.addListSelectionListener(this);
            TableColumnModel columnModel = this.m_propertyTable.getColumnModel();
            TableColumn aColumn = columnModel.getColumn(0);
            aColumn.setMinWidth(20);
            aColumn.setMaxWidth(20);
            aColumn.setHeaderRenderer(new VWTableHeaderRenderer(VWSIMImageLoader.createImageIcon("status_16.gif"), VWSIMResource.Status));
            aColumn.setCellRenderer(new VWSIMSimulationStatusRender());
            aColumn = columnModel.getColumn(1);
            aColumn.setMinWidth(20);
            aColumn.setMaxWidth(20);
            aColumn.setHeaderRenderer(new VWTableHeaderRenderer(VWSIMImageLoader.createImageIcon("pub_data_16.gif"), VWSIMResource.PublishedData));
            aColumn = columnModel.getColumn(2);
            aColumn.setPreferredWidth(30);
            aColumn.setCellRenderer(new VWSIMCategoryRender());
            aColumn = columnModel.getColumn(3);
            aColumn.setPreferredWidth(150);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void releaseResources() {
        this.m_contentViewPane = null;
        if (this.m_aMouseAdapter != null) {
            this.m_aMouseAdapter.removeReferences();
            this.m_aMouseAdapter = null;
        }
        if (this.m_propertyTable != null) {
            this.m_propertyTable.removeAll();
            this.m_propertyTable = null;
        }
        if (this.m_nodeList != null) {
            this.m_nodeList.removeAllElements();
            this.m_nodeList = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.releaseResources();
            this.m_tableModel = null;
        }
        this.m_performer = null;
        this.removeAll();
    }
}

